#***************************************************************************/
#* FILE NAME: simulator_init.s              COPYRIGHT (c) Freescale 2004   */
#*                                                All Rights Reserved      */
#* DESCRIPTION:                                                            */
#* This file sets up the MMU for the MPC5554 simulator                     */
#*=========================================================================*/
#* ORIGINAL AUTHOR:                                                        */
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE                */
#* ---   -----------    ----------    ---------------------                */
#* 0.1   G. Jackson     13/Nov/03     Initial MMU_init.c                   */
#* 0.2   C. Coombs      02/Dec/03     Cut down to initialise SRAM/flash    */
#* 0.3   G. Jackson     15/Apr/04     Assembler MMU_init.s version         */
#* 0.4   G. Jackson     13/May/04     Name changed to simulator_init.s     */
#* 1.0   G. Jackson     12/Oct/04     Green Hills now does not require     */
#*                                     quotation marks around the section  */
#*                                    Added syntax to generate symbols for */
#*                                     debug.                              */
#***************************************************************************/

    .include "mpc5500_usrdefs.inc"
  
###################################################################
#  This is the start of the .init section for the simulator only. 
    
    .if __PEGNU__
    .section ".init","ax" # The "ax" is required to generate "non-text" code
    .endif

    .if __GRNHS__
    .section .init,ax     # The "ax" generates symbols for debug
    .endif

    .if __DIABCC__
    .section .init,c      # The "c" generates symbols for debug
    .endif
    
     .if __CWWRKS__
    .section .init,text   # The "text" generates symbols for debug
    .endif
    

#*************** TLB setup macros and constants ***************

#*****************************************************************************/
# FUNCTION     : __inite200Z6                                                */
# PURPOSE      : This function modifies the Simulator MMU TLB (translation   */
#                 lookaside buffer) table by writing to the appropriate MAS  */
#                 registers.                                                 */
# INPUT NOTES  : Requires SPRs defined and a data table for the TLB entries  */
#                sim_mmu_tlb1, sim_mmu_tlb3, and sim_mmu_tlb5                */
# RETURN NOTES : None                                                        */
# WARNING      : Registers used: R3,R5                                       */
#*****************************************************************************/

__inite200Z6:
# Change the TLB5 Internal Flash 1 size to 1M.    
    lis r3, sim_mmu_tlb5@h    # base address of MAS Constants
    ori r3,r3, sim_mmu_tlb5@l
    lwz r5,0(r3)              # Get MAS0 value
    mtspr mas0,r5             # mtspr MAS0,r5
    lwzu r5,4(r3)             # Get MAS1 value
    mtspr mas1,r5             # mtspr MAS1,r5
    lwzu r5,4(r3)             # Get MAS2 value
    mtspr mas2,r5             # mtspr MAS2,r5
    lwzu r5,4(r3)             # Get MAS3 value
    mtspr mas3,r5             # mtspr MAS3,r5
    tlbwe                     # Write the entry to the TLB 

# Change the TLB1 Internal FLASH 2 size to 1M.    
    lis r3, sim_mmu_tlb1@h    # base address of MAS Constants
    ori r3,r3, sim_mmu_tlb1@l
    lwz r5,0(r3)              # Get MAS0 value
    mtspr mas0,r5             # mtspr MAS0,r5
    lwzu r5,4(r3)             # Get MAS1 value
    mtspr mas1,r5             # mtspr MAS1,r5
    lwzu r5,4(r3)             # Get MAS2 value
    mtspr mas2,r5             # mtspr MAS2,r5
    lwzu r5,4(r3)             # Get MAS3 value
    mtspr mas3,r5             # mtspr MAS3,r5
    tlbwe                     # Write the entry to the TLB 
    
# Change the TLB3 SRAM size to 1M.    
    lis r3, sim_mmu_tlb3@h    # base address of MAS Constants
    ori r3,r3, sim_mmu_tlb3@l
    lwz r5,0(r3)              # Get MAS0 value
    mtspr mas0,r5             # mtspr MAS0,r5
    lwzu r5,4(r3)             # Get MAS1 value
    mtspr mas1,r5             # mtspr MAS1,r5
    lwzu r5,4(r3)             # Get MAS2 value
    mtspr mas2,r5             # mtspr MAS2,r5
    lwzu r5,4(r3)             # Get MAS3 value
    mtspr mas3,r5             # mtspr MAS3,r5
    tlbwe                     # Write the entry to the TLB 

    blr

#*************** End Initialise MMU ****************
    
#**************************************************************************/
# FUNCTION     : MMU DATA Tables                                          */
# PURPOSE      : This references the information set up above.            */
#                                                                         */
# INPUT NOTES  : Requires that the TLB settings be above                  */
# RETURN NOTES : mmu_tlb1 [SIM_TLB1_MAS[0:3], mmu_tlb3 [SIM_TLB3_MAS[0:3],*/
#                mmu_tlb5 [SIM_TLB5_MAS[0:3]                              */
# WARNING      : Registers used: none                                     */
#**************************************************************************/

# Section declaration:

    .if __PEGNU__
    .section ".rodata" 
    .endif

    .if __CWWRKS__ | __DIABCC__ | __GRNHS__
    .section .rodata
    .endif

#*************** TLB setup macros and constants ****************/
#************************************************

#*********************************************************************/
#* DESCRIPTION:                                                      */  
#* This table contains definitions for the Simulator MPC5554 MMU TLB */
#*     entries. The bit definitions used in the TLB defines are      */
#*     located in mpc5500_defs.inc.                                  */  
#* The second half of the file is the TLB setup code.                */
#*********************************************************************/ 


# DESCRIPTION:                                                           
# This table contains definitions for the Simulator MPC5554 MMU TLB entries,     
# replacing the MACROs that the GHS assembler will not assemble. The    
# bit definitions used in the TLB defines are located above. 
# The second half of the file is the TLB setup code.                    

#** TLB DEFINES **
#*** TLB 3 - Internal SRAM ***/
sim_mmu_tlb3:
# SIM_TLB3_MAS0
    .long ( TLB_SELECT | TLB_ENTRY3 )
# SIM_TLB3_MAS1
    .long ( TLB_ENTRY_VALID | ENTRY_PROTECTED | GLOBAL_MATCH | TS_IS_COMPARE | TSIZ_64K )
# SIM_TLB3_MAS2
    .long ( SRAM_BASE_ADDR | CACHE_WRITE_BACK | CACHE_ACTIVE | MEM_NO_COHERENCE | PAGE_NOT_GUARDED | PAGE_BIG_ENDIAN )
# SIM_TLB3_MAS3
    .long ( SRAM_BASE_ADDR | READWRITEEXECUTE )
    
#*** TLB 5 - Internal Flash 1 ***/
sim_mmu_tlb5:
# SIM_TLB5_MAS0
    .long ( TLB_SELECT | TLB_ENTRY5 )
# SIM_TLB5_MAS1
    .long ( TLB_ENTRY_VALID | ENTRY_PROTECTED | GLOBAL_MATCH | TS_IS_COMPARE | TSIZ_1M )
# SIM_TLB5_MAS2
    .long ( FLASH_BASE_ADDR | CACHE_WRITE_BACK | CACHE_ACTIVE | MEM_NO_COHERENCE | PAGE_NOT_GUARDED | PAGE_BIG_ENDIAN )
# SIM_TLB5_MAS3
    .long ( FLASH_BASE_ADDR | READWRITEEXECUTE )

#*** TLB 1 - Internal FLASH 2 ***/
sim_mmu_tlb1:
# SIM_TLB1_MAS0
    .long ( TLB_SELECT | TLB_ENTRY6 )
# SIM_TLB1_MAS1
    .long ( TLB_ENTRY_VALID | ENTRY_PROTECTED | GLOBAL_MATCH | TS_IS_COMPARE | TSIZ_256K )
# SIM_TLB1_MAS2
    .long ( (FLASH_BASE_ADDR + OFFSET_1M) | CACHE_WRITE_BACK | CACHE_ACTIVE | MEM_NO_COHERENCE | PAGE_NOT_GUARDED | PAGE_BIG_ENDIAN )
# SIM_TLB1_MAS3
    .long ( (FLASH_BASE_ADDR + OFFSET_1M) | READWRITEEXECUTE )    

#*************** End MMU Simulation Definitions ****************

